#**************************************************************************/
#* FILE NAME:                              COPYRIGHT (c) Freescale 2008   */
#* Vector_SW_VLE - Z3_Z4_Z6_Z7.s                  All Rights Reserved     */
#*                                                                        */
#* DESCRIPTION:                                                           */
#* This is a generic base template for setting up the IVPR and IVOR       */
#* registers for the e200z3, z4, z6 and z7 cores.                         */
#*                                                                        */
#* This file also includes a trap for all core exceptions, excluding      */
#* IVOR4 exceptions which have seperate handler                           */
#*                                                                        */
#* Syntax specifically written for GHS v5.x compiler. This file starts in */
#* memory at the beginning of the ".xptn_vectors" section.                */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    R. Moran       10/12/2008    Initial Version                    */
#**************************************************************************/
    .globl   IVOR0_Handler
    .globl   IVOR1_Handler
    .globl   IVOR2_Handler
    .globl   IVOR3_Handler

    .globl   IVOR5_Handler
    .globl   IVOR6_Handler
    .globl   IVOR7_Handler
    .globl   IVOR8_Handler
    .globl   IVOR9_Handler
    .globl   IVOR10_Handler
    .globl   IVOR11_Handler
    .globl   IVOR12_Handler
    .globl   IVOR13_Handler
    .globl   IVOR14_Handler
    .globl   IVOR15_Handler

    .globl   e200zX_Interrupt_Setup
    
    .section    ".xptn_vectors", "va"
    .vle

.align 4    
IVORnTable:    
#=================================================
#               IVOR 0 Handler
#=================================================           
IVOR0_Handler:
    nop
    e_b IVOR0_Handler
#=================================================
#               IVOR 1 Handler
#=================================================           
.offset 0x10
IVOR1_Handler:
    nop
    e_b IVOR1_Handler
#=================================================
#               IVOR 2 Handler
#=================================================              
.offset 0x20
IVOR2_Handler:
    nop
    e_b IVOR2_Handler
#=================================================
#               IVOR 3 Handler
#=================================================              
.offset 0x30
IVOR3_Handler:
    nop
    e_b IVOR3_Handler
#=================================================
#               IVOR 4 Handler
#================================================= 

# IVOR 4 Handled in seperate file

#=================================================
#               IVOR 5 Handler
#=================================================              
.offset 0x50
IVOR5_Handler:
    nop
    e_b IVOR5_Handler
#=================================================
#               IVOR 6 Handler
#=================================================              
.offset 0x60
IVOR6_Handler:
    nop
    e_b IVOR6_Handler
#=================================================
#               IVOR 7 Handler
#=================================================              
.offset 0x70
IVOR7_Handler:
    nop
    e_b IVOR7_Handler
#=================================================
#               IVOR 8 Handler
#=================================================              
.offset 0x80
IVOR8_Handler:
    nop
    e_b IVOR8_Handler
#=================================================
#               IVOR 9 Handler
#=================================================              
.offset 0x90
IVOR9_Handler:
    nop
    e_b IVOR9_Handler
#=================================================
#               IVOR 10 Handler
#=================================================              
.offset 0x100
IVOR10_Handler:
    nop
    e_b IVOR10_Handler    
#=================================================
#               IVOR 11 Handler
#=================================================              
.offset 0x110
IVOR11_Handler:
    nop
    e_b IVOR11_Handler    
#=================================================
#               IVOR 12 Handler
#=================================================              
.offset 0x120
IVOR12_Handler:
    nop
    e_b IVOR12_Handler
#=================================================
#               IVOR 13 Handler
#=================================================              
.offset 0x130
IVOR13_Handler:
    nop
    e_b IVOR13_Handler
#=================================================
#               IVOR 14 Handler
#=================================================              
.offset 0x140
IVOR14_Handler:
    nop
    e_b IVOR14_Handler                                                  
#=================================================
#               IVOR 15 Handler
#=================================================              
.offset 0x150
IVOR15_Handler:                             
    nop                           
    e_b IVOR15_Handler                                                              
    

#=================================================
#  Function to Setup the Core Interrupt Registers
#=================================================              
e200zX_Interrupt_Setup:

    #IVPR = address base used with IVOR's
    e_lis r5, __IVPR@h   
    e_or2i r5, __IVPR@l
    mtIVPR r5 
    
    # Setup IVORx Registers
    e_lis r5, IVOR0_Handler@h
    e_or2i r5, IVOR0_Handler@l
    mtIVOR0 r5
    
    e_lis r5, IVOR1_Handler@h
    e_or2i r5, IVOR1_Handler@l
    mtIVOR1 r5
    
    e_lis r5, IVOR2_Handler@h
    e_or2i r5, IVOR2_Handler@l
    mtIVOR2 r5
    
    e_lis r5, IVOR3_Handler@h
    e_or2i r5, IVOR3_Handler@l
    mtIVOR3 r5
    
    e_lis r5, IVOR4_Handler@h
    e_or2i r5, IVOR4_Handler@l
    mtIVOR4 r5
    
    e_lis r5, IVOR5_Handler@h
    e_or2i r5, IVOR5_Handler@l
    mtIVOR5 r5
    
    e_lis r5, IVOR6_Handler@h
    e_or2i r5, IVOR6_Handler@l
    mtIVOR6 r5
    
    e_lis r5, IVOR7_Handler@h
    e_or2i r5, IVOR7_Handler@l
    mtIVOR7 r5
    
    e_lis r5, IVOR8_Handler@h
    e_or2i r5, IVOR8_Handler@l
    mtIVOR8 r5
    
    e_lis r5, IVOR9_Handler@h
    e_or2i r5, IVOR9_Handler@l
    mtIVOR9 r5
    
    e_lis r5, IVOR10_Handler@h
    e_or2i r5, IVOR10_Handler@l
    mtIVOR10 r5
    
    e_lis r5, IVOR11_Handler@h
    e_or2i r5, IVOR11_Handler@l
    mtIVOR11 r5
    
    e_lis r5, IVOR12_Handler@h
    e_or2i r5, IVOR12_Handler@l
    mtIVOR12 r5
    
    e_lis r5, IVOR13_Handler@h
    e_or2i r5, IVOR13_Handler@l
    mtIVOR13 r5
    
    e_lis r5, IVOR14_Handler@h
    e_or2i r5, IVOR14_Handler@l
    mtIVOR14 r5
    
    e_lis r5, IVOR15_Handler@h
    e_or2i r5, IVOR15_Handler@l
    mtIVOR15 r5
    
    se_blr
    
